<?php
// *****************************************************************************
// $Date: 2023-01-01 14:19:40 +0000 (Sun, 01 Jan 2023) $
// $Author: tony $
// $Revision: 42 $
// *****************************************************************************

// Each entry must be an array of values

$array['boolean']    = array('true' => 'Yes',
                             'false' => 'No');

$array['boolean_10'] = array('1' => 'Yes',
                             '0' => 'No');

$array['boolean_TF'] = array('T' => 'Yes',
                             'F' => 'No');

$array['boolean_YN'] = array('Y' => 'Yes',
                             'N' => 'No');

// this version prevents the 'undefined' entry from being added in SEARCH screens
$array['boolean_no_undef'] = array('Y' => 'Yes',
                                   'N' => 'No');

$array['curr_or_hist'] = array('C' => 'Current',
                               'H' => 'Historic',
                               'F' => 'Future',
                               'A' => 'All');

$array['day_names_short']  = array('mon' => 'Mon',
                                   'tue' => 'Tue',
                                   'wed' => 'Wed',
                                   'thu' => 'Thu',
                                   'fri' => 'Fri',
                                   'sat' => 'Sat',
                                   'sun' => 'Sun');
// Japanese/Chinese characters
$ja_day   = pack("CCC",0xe6,0x97,0xa5);
$ja_month = pack("CCC",0xe6,0x9c,0x88);
$ja_year  = pack("CCC",0xe5,0xb9,0xb4);
// Korean characters
$ko_day   = pack("CCC",0xec,0x9d,0xbc);
$ko_month = pack("CCC",0xec,0x9b,0x94);
$ko_year  = pack("CCC",0xeb,0x85,0x84);
// Thai characters
$th_month1 = pack("CCC",0xe0,0xb8,0xa1);
$th_month2 = pack("CCC",0xe0,0xb8,0x84);

$array['date_format']  = array('dd mm yyyy'    => 'dd mm yyyy (09 01 2006)',
                               'dd.mm.yyyy'    => 'dd.mm.yyyy (09.01.2006)',
                               'dd-mm-yyyy'    => 'dd-mm-yyyy (09-01-2006)',
                               'dd/mm/yyyy'    => 'dd/mm/yyyy (09/01/2006)',
                               'dd/mm yyyy'    => 'dd/mm yyyy (09/01 2006)',
                               'dd/mm/yy'      => 'dd/mm/yy (09/01/06)',
                               'd/mm/yyyy'     => 'd/mm/yyyy (9/01/2006)',
                               'd.m.yyyy'      => 'd.m.yyyy (9.1.2006)',
                               'd. m. yyyy'    => 'd. m. yyyy (9. 1. 2006)',
                               'dd. mm. yyyy.' => 'dd. mm. yyyy. (09. 01. 2006.)',
                               'dd MMM yyyy'   => 'dd MMM yyyy (09 Jan 2006)',
                               'd MMM yyyy'    => 'd MMM yyyy (9 Jan 2006)',
                               'mm dd yyyy'    => 'mm dd yyyy (01 09 2006)',
                               'm/d/yyyy'      => 'm/d/yyyy (1/9/2006)',
                               'MMM dd yyyy'   => 'MMM dd yyyy (Jan 09 2006)',
                               'yyyy-mm-dd'    => 'yyyy-mm-dd (2006-01-09)',
                               'yyyy/mm/dd'    => 'yyyy/mm/dd (2006/01/09)',
                               'yyyy.mm.dd'    => 'yyyy.mm.dd (2006.01.09)',
                               'yyyy. mm. dd'  => 'yyyy. mm. dd (2006. 01. 09)',
                               'yyyy MMM dd'   => 'yyyy MMM dd (2006 Jan 09)',
                               'dd MMM yyyy [th]'   => "dd $th_month1.$th_month2. yyyy (09 Jan 2006) [th]",
                               'yyyy#mm#dd# [ja]'   => 'yyyy'.$ja_year.'mm' .$ja_month.'dd' .$ja_day.' (2006*01*09*) [ja]',
                               'yyyy# mm# dd# [ko]' => 'yyyy'.$ko_year.' mm'.$ko_month.' dd'.$ko_day.' (2006* 01* 09*) [ko]',
                               'yyyy#m#d# [zh_XX]'  => 'yyyy'.$ja_year.'m'  .$ja_month.'d'  .$ja_day.' (2006*1*9*) [zh_HK/MO/SG/TW]');

$array['day_names_long']  = array('monday' => 'Monday',
                                  'tuesday' => 'Tuesday',
                                  'wednesday' => 'Wednesday',
                                  'thursday' => 'Thursday',
                                  'friday' => 'Friday',
                                  'saturday' => 'Saturday',
                                  'sunday' => 'Sunday');

$array['day_numbers']  = array('1' => 'Monday',
                               '2' => 'Tuesday',
                               '3' => 'Wednesday',
                               '4' => 'Thursday',
                               '5' => 'Friday',
                               '6' => 'Saturday',
                               '7' => 'Sunday');

$array['day_numbers_short']  = array('1' => 'Mon',
                                     '2' => 'Tue',
                                     '3' => 'Wed',
                                     '4' => 'Thu',
                                     '5' => 'Fri',
                                     '6' => 'Sat',
                                     '7' => 'Sun');

$array['month_names_short']  = array(1 => 'Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec');

$array['month_names_long']  = array(1 => 'January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December');

// the values enclosed in '[' and ']' are the equivalent locale names
$array['languages'] = load_language_data();
//$array['languages'] = array('af' => 'Afrikaans [af]',
//	                        'sq' => 'Albanian [sq]',
//	                        'ar-dz' => 'Arabic (Algeria) [ar_DZ]',
//        	                'ar-bh' => 'Arabic (Bahrain) [ar_BH]',
//        	                'ar-eg' => 'Arabic (Egypt) [ar_EG]',
//        	                'ar-iq' => 'Arabic (Iraq) [ar_IQ]',
//        	                'ar-jo' => 'Arabic (Jordan) [ar_JO]',
//        	                'ar-kw' => 'Arabic (Kuwait) [ar_KW]',
//        	                'ar-lb' => 'Arabic (Lebanon) [ar_LB]',
//        	                'ar-ly' => 'Arabic (libya) [ar_LY]',
//        	                'ar-ma' => 'Arabic (Morocco) [ar_MA]',
//        	                'ar-om' => 'Arabic (Oman) [ar_OM]',
//        	                'ar-qa' => 'Arabic (Qatar) [ar_QA]',
//        	                'ar-sa' => 'Arabic (Saudi Arabia) [ar_SA]',
//        	                'ar-sy' => 'Arabic (Syria) [ar_SY]',
//        	                'ar-tn' => 'Arabic (Tunisia) [ar_TN]',
//        	                'ar-ae' => 'Arabic (U.A.E.) [ar_AE]',
//        	                'ar-ye' => 'Arabic (Yemen) [ar_YE]',
//        	                'ar' => 'Arabic [ar]',
//        	                'hy' => 'Armenian [hy]',
//        	                'as' => 'Assamese [as]',
//        	                'az' => 'Azeri [az]',
//        	                'eu' => 'Basque [es_EU]',
//        	                'be' => 'Belarusian [be_BE]',
//        	                'bn' => 'Bengali [bn]',
//        	                'bg' => 'Bulgarian [bg]',
//        	                'ca' => 'Catalan [es_CA]',
//        	                'zh-cn' => 'Chinese (China) [zh_CN]',
//        	                'zh-hk' => 'Chinese (Hong Kong SAR) [zh_HK]',
//        	                'zh-mo' => 'Chinese (Macau SAR) [zh_MO]',
//        	                'zh-sg' => 'Chinese (Singapore) [zh_SG]',
//        	                'zh-tw' => 'Chinese (Taiwan) [zh_TW]',
//        	                'zh' => 'Chinese [zh]',
//        	                'hr' => 'Croatian [hr]',
//        	                'cs' => 'Chech [cs]',
//        	                'da' => 'Danish [da]',
//        	                'div' => 'Divehi [div]',
//        	                'nl-be' => 'Dutch (Belgium) [nl_BE]',
//        	                'nl' => 'Dutch (Netherlands) [nl]',
//        	                'en-au' => 'English (Australia) [en_AU]',
//        	                'en-bz' => 'English (Belize) [en_BR]',
//        	                'en-ca' => 'English (Canada) [en_CA]',
//        	                'en-ie' => 'English (Ireland) [en_IE]',
//        	                'en-jm' => 'English (Jamaica) [en_JM]',
//        	                'en-nz' => 'English (New Zealand) [en_NZ]',
//        	                'en-ph' => 'English (Philippines) [en_PH]',
//        	                'en-za' => 'English (South Africa) [en_ZA]',
//        	                'en-tt' => 'English (Trinidad) [en_TT]',
//        	                'en-gb' => 'English (United Kingdom) [en_GB]',
//        	                'en-us' => 'English (United States) [en_US]',
//        	                'en-zw' => 'English (Zimbabwe) [en_ZW]',
//        	                'en' => 'English [en]',
//        	                'et' => 'Estonian [et]',
//        	                'fo' => 'Faeroese [fo]',
//        	                'fa' => 'Farsi [fa]',
//        	                'fi' => 'Finnish [fi]',
//        	                'fr-be' => 'French (Belgium) [fr_BE]',
//        	                'fr-ca' => 'French (Canada) [fr_CA]',
//        	                'fr-lu' => 'French (Luxembourg) [fr_LU]',
//        	                'fr-mc' => 'French (Monaco) [fr_MC]',
//        	                'fr-ch' => 'French (Switzerland) [fr_CH]',
//        	                'fr' => 'French (France) [fr]',
//        	                'mk' => 'FYRO Macedonian [mk]',
//        	                'gd' => 'Gaelic [gd]',
//        	                'ka' => 'Georgian [ka]',
//        	                'de-at' => 'German (Austria) [de_AT]',
//        	                'de-li' => 'German (Liechtenstein) [de_LI]',
//        	                'de-lu' => 'German (luxembourg) [de_LU]',
//        	                'de-ch' => 'German (Switzerland) [de_CH]',
//        	                'de' => 'German (Germany) [de]',
//        	                'el' => 'Greek [el]',
//        	                'gu' => 'Gujarati [gu]',
//        	                'he' => 'Hebrew [he]',
//        	                'hi' => 'Hindi [hi]',
//        	                'hu' => 'Hungarian [hu]',
//        	                'is' => 'Icelandic [is]',
//        	                'id' => 'Indonesian [id]',
//        	                'it-ch' => 'Italian (Switzerland) [it_CH]',
//        	                'it' => 'Italian (Italy) [it]',
//        	                'ja' => 'Japanese [ja]',
//        	                'kn' => 'Kannada [kn]',
//        	                'kk' => 'Kazakh [kk]',
//        	                'kok' => 'Konkani [kk]',
//        	                'ko' => 'Korean [ko]',
//        	                'kz' => 'Kyrgyz [kz]',
//        	                'lv' => 'Latvian [lv]',
//        	                'lt' => 'Lithuanian [lt]',
//        	                'ms' => 'Malay [ms]',
//        	                'ml' => 'Malayalam [ml]',
//        	                'mt' => 'Maltese [mt]',
//        	                'mr' => 'Marathi [mr]',
//        	                'mn' => 'Mongolian (Cyrillic) [mn]',
//        	                'ne' => 'Nepali (India) [ne]',
//        	                'nb-no' => 'Norwegian (Bokmal) [nb_NO]',
//        	                'nn-no' => 'Norwegian (Nynorsk) [nn_NO]',
//        	                'no' => 'Norwegian (Bokmal) [no]',
//        	                'or' => 'Oriya [or]',
//        	                'pl' => 'Polish [pl]',
//        	                'pt-br' => 'Portuguese (Brazil) [pt_BR]',
//        	                'pt' => 'Portuguese (Portugal) [pt]',
//        	                'pa' => 'Punjabi [pa]',
//        	                'rm' => 'Rhaeto-Romanic [rm]',
//        	                'ro-md' => 'Romanian (Moldova) [ro_MD]',
//        	                'ro' => 'Romanian [ro]',
//        	                'ru-md' => 'Russian (Moldova) [ru_MD]',
//        	                'ru' => 'Russian [ru]',
//        	                'sa' => 'Sanskrit [sa]',
//        	                'sr' => 'Serbian[sr]',
//        	                'sk' => 'Slovak [sk]',
//        	                'ls' => 'Slovenian [ls]',
//        	                'sb' => 'Sorbian [sb]',
//        	                'es-ar' => 'Spanish (Argentina) [es_AR]',
//        	                'es-bo' => 'Spanish (Bolivia) [es_BO]',
//        	                'es-cl' => 'Spanish (Chile) [es_CL]',
//        	                'es-co' => 'Spanish (Colombia) [es_CO]',
//        	                'es-cr' => 'Spanish (Costa Rica) [es_CR]',
//        	                'es-do' => 'Spanish (Dominican Republic) [es_DO]',
//        	                'es-ec' => 'Spanish (Ecuador) [es_EC]',
//        	                'es-sv' => 'Spanish (El Salvador) [es_SV]',
//        	                'es-gt' => 'Spanish (Guatemala) [es_GT]',
//        	                'es-hn' => 'Spanish (Honduras) [es_HN]',
//        	                'es-mx' => 'Spanish (Mexico) [es_MX]',
//        	                'es-ni' => 'Spanish (Nicaragua) [es_NI]',
//        	                'es-pa' => 'Spanish (Panama) [es_PA]',
//        	                'es-py' => 'Spanish (Paraguay) [es_PY]',
//        	                'es-pe' => 'Spanish (Peru) [es_PE]',
//        	                'es-pr' => 'Spanish (Puerto Rico) [es_PR]',
//        	                'es-us' => 'Spanish (United States) [es_US]',
//        	                'es-uy' => 'Spanish (Uruguay) [es_UY]',
//        	                'es-ve' => 'Spanish (Venezuela) [es_VE]',
//        	                'es' => 'Spanish (Spain) [es]',
//        	                'sx' => 'Sutu [sx]',
//        	                'sw' => 'Swahili [sw]',
//        	                'sv-fi' => 'Swedish (Finland) [sv_FI]',
//        	                'sv' => 'Swedish [sv]',
//        	                'syr' => 'Syriac [syr]',
//        	                'ta' => 'Tamil [ta]',
//        	                'tt' => 'Tatar [tt]',
//        	                'te' => 'Telugu [te]',
//        	                'th' => 'Thai [th]',
//        	                'ts' => 'Tsonga [ts]',
//                   		    'tn' => 'Tswana [tn]',
//                   		    'tr' => 'Turkish [tr]',
//                   		    'uk' => 'Ukrainian [uk]',
//                   		    'ur' => 'Urdu [ur]',
//                   		    'uz' => 'Uzbek [uz]',
//                   		    'vi' => 'Vietnamese [vi]',
//                   		    'xh' => 'Xhosa [xh]',
//                   		    'yi' => 'Yiddish [yi]',
//                   		    'zu' => 'Zulu [zu]' );

$array['selected']  = array('Y' => 'Selected',
                            'N' => 'No');

$array['time_period']  = array('DAY' => 'Days',
                               'WEEK' => 'Weeks',
                               'MONTH' => 'Months',
                               'YEAR' => 'Years');

return $array;

?>