<?xml version='1.0'?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" 
                xmlns:USOURCE="USOURCE.DICT">

<xsl:output method='html' />

<xsl:template match="/">

  <html>
    <head>
      <STYLE type="text/css">
      <![CDATA[
      <!--
        BODY { margin-left: 5%; margin-right: 5%; }
        H1 { margin-bottom: 0px }
        TR.contents { background-color: #ccffff; }
        TR.hdg { background-color: #99ff99; }
        TR.code { background-color: #dddddd; }
      -->
      ]]>
      </STYLE>
    </head>
  <body>

    <table border="1" cellpadding="6px">
      <caption><h1>Global Procs</h1></caption>
      <tr><th>Library</th><th>Module</th><th>Description</th></tr>

      <xsl:apply-templates select="/UNIFACE/TABLE/OCC[USOURCE:UVAR]" mode="toc">
        <xsl:sort select="USOURCE:UVAR"/>
        <xsl:sort select="USOURCE:ULABEL"/>
      </xsl:apply-templates>

    </table>
    <br />

    <table border="1" cellpadding="6px"  width="100%">

    <xsl:apply-templates select="/UNIFACE/TABLE/OCC[USOURCE:UVAR]">
      <xsl:sort select="USOURCE:UVAR"/>
      <xsl:sort select="USOURCE:ULABEL"/>
    </xsl:apply-templates>

    </table>

  </body>
  </html>

</xsl:template>

<xsl:template match="/UNIFACE/TABLE/OCC" mode="toc">

    <tr class="contents">
      <td><xsl:value-of select="USOURCE:UVAR"/></td>
      <td><a href="#{USOURCE:UVAR}:{USOURCE:ULABEL}"><xsl:value-of select="USOURCE:ULABEL"/></a></td>
      <td><xsl:value-of select="USOURCE:UDESCR"/></td>
    </tr>

    <xsl:variable name="position" select="position()" />
    <xsl:variable name="next" select="/UNIFACE/TABLE/OCC[$position+1]/USOURCE:UVAR" />
    <xsl:if test="USOURCE:UVAR != $next">
      <tr><td colspan="3">&#xa0;</td></tr>
    </xsl:if>

</xsl:template>

<xsl:template match="UNIFACE/TABLE/OCC">

    <tr class="hdg">
      <td><xsl:value-of select="USOURCE:UVAR"/></td>
      <td><a name="{USOURCE:UVAR}:{USOURCE:ULABEL}"><xsl:value-of select="USOURCE:ULABEL"/></a></td>
      <td><xsl:value-of select="USOURCE:UDESCR"/></td>
    </tr>
    <tr class="code">
      <td colspan="3"><pre><xsl:value-of select="USOURCE:UTEXT"/></pre></td>
    </tr>
    <tr><td colspan="3">&#xa0;</td></tr>

</xsl:template>

</xsl:stylesheet>
